#!/bin/bash

API_SERVER=api.mnogoweb.com/v1/dns/dyndns
API_KEY=<API_KEY>
DOMAIN=<DOMAIN>
RECORD_NAME=<RECORD_NAME>

UPDATE=false
NEW_IP =$(dig -4 TXT +short o-o.myaddr.l.google.com @ns1.google.com)
IP_FILE=current_ip.txt

echo "Current IP address: $NEW_IP"
if [ ! -f $IP_FILE ] ; then
    UPDATE=true
else
    OLD_IP=$(cat $IP_FILE)
    if [ "$OLD_IP" != "$NEW_IP" ] ; then
        UPDATE=true;
    fi
fi

if [ $UPDATE == "false" ] ; then
	echo "IP address update is not needed"
	exit
fi

echo $NEW_IP > $IP_FILE
echo "IP address changed, update is needed"
curl -D - --header "Autorization: Bearer $API_KEY" https://$API_SERVER?domain=$DOMAIN&name=$RECORD_NAME